<?php

	/*
	Nom du script : php_mysql_suppression_ville.php
	Auteur : Christian VIGOUROUX
	Date de création : 13/07/2024
	Date de dernière modification : 13/07/2024
	Objet : Suppression d'un enregistrement dans la table MySQL villes de la BDD MySQL
	*/

	// Headers
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
	header('Access-Control-Allow-Headers: Content-Type');
	header('Content-Type: application/json');

	// Paramètres de la connexion
	$nom_serveur = "nom_serveur";
	$nom_utilisateur = "nom_utilisateur";
	$mot_de_passe = "mot_de_passe";
	$base_de_donnees = "base_de_donnees";

	// Création de la connexion
	$conn = new mysqli($nom_serveur, $nom_utilisateur, $mot_de_passe, $base_de_donnees);

	// Vérification de la connexion
	if ($conn->connect_error) {
		die(json_encode(['success' => false, 'message' => 'Connection failed: ' . $conn->connect_error]));
	}

	// Récupération de l'ID de la ville depuis les paramètres GET
	$id_ville = $_GET['id_ville'] ?? '';

	// Test de l'ID de la ville (non vide)
	if (empty($id_ville)) {
		die(json_encode(['success' => false, 'message' => 'ID de la ville est vide']));
	}

	// Préparation et exécution de la requête SQL
	$stmt = $conn->prepare("DELETE FROM villes WHERE id_ville = ?");
	if (!$stmt) {
		die(json_encode(['success' => false, 'message' => 'Prepare failed: ' . $conn->error]));
	}
	$stmt->bind_param("i", $id_ville);

	// Evaluation de l'exécution de la requête SQL
	if ($stmt->execute()) {
		if ($stmt->affected_rows > 0) {
			echo json_encode(['success' => true]);
		} else {
			echo json_encode(['success' => false, 'message' => 'No rows affected']);
		}
	} else {
		echo json_encode(['success' => false, 'message' => 'Execute failed: ' . $stmt->error]);
	}

	// Libération des ressources
	$stmt->close();
	$conn->close();

?>